###########
########### This function contains all the test functions
########### for simulation purposes: Simba, Beach, Drum, Micha, etc.
camel <- function( X , P, name = 'skate', slope = NULL){
  # P should be the original dimensional problem
  # keeping track of WHICH variables are actually used ... 
  # adding random entries for unobserved columns 
  if( !is.null( colnames(X) )){
    # P = 2;
    neednames = paste("X",1:P, sep  ="")
    xnames = colnames(X)
    
    ## unless variables given, we use random uniform entries
    XX = matrix( runif(length(X)*P), nrow(X), P)
    
    XX[, is.element(neednames, xnames)  ] = X
    X <- XX
  } else # if we know the column names, use them
    
    if( is.null(colnames(X))  & ncol(X) < P ){
      
      need = P - ncol(X)
      XX = matrix( runif(length(X)*P), nrow(X), P)
      
      colnames(XX) = paste("X", 1:P , sep="")
      XX[, 1:ncol(X)] = X
      X <- XX
    }# otherwise, we just require dimensions to match
  
  ### new test function
  
  #### 1/11/18: surrogate for robot
  if(name == 'robot'){ ############
    #################################
    colnames(XXX) = paste("X",1:21, sep= "")
    if( is.null(dim(X))){ 
      p = length(X);
      X = matrix( X, ncol = p); 
      colnames(X) = paste("X",1:p, sep= "")
    }# end no info on columns of x, or dimension
    
    if(is.null( colnames(X)))  colnames(X) = paste("X",1:p, sep= "")
    
    if( is.null(p)) p = ncol(X)
    
    d2  = rdist( matrix(X[,colnames(X)], ncol = p), 
                 XXX[,colnames(X)]) ^2
    w   = exp( - d2 / 0.08272 ^2 )
    w   = sweep( w, 1, rowSums(w) + 1e-88 , "/")
    Y   = w %*% YYY 
    
    ################
    return(Y)#######
  }# end robot ###
  ################
  
  if(name == 'sines'){
    
    #mm = 50; X = makepts(mm = mm, p = 6)
    # X = X[,c(2,3,4,5,1)] 
    
    x1 = X[,1] ; x2 = X[,2]; x3 = X[,3];
    x4 = X[,4] ; x5 = X[,5]; x6 = X[,6];
    
    # # library(rgl)
    # par(mfrow=c(2,2))
    # library(fields)
    # for( v in seq(0,1, length.out = 8)){
    #   x3 = x4 =x5 = x6 = 0.4
    #   x3 = v
    # library(MASS)
    ### x3: handles the amplitude of the x1 curve
    ### x4: handles the amplitude of the x2 curve
    ### x5: controls the periodicty and amplitude 
    ### x6: likewise
    
    Y = ((x1 - .21)^2*dnorm( x1 - .21, mean = 0, sd = 0.5 ) + 
           (x2 - .22)^2*dnorm( x2 - .22, mean = 0, sd = 0.5 ) +
           (x3 - .23)^2*dnorm( x3 - .23, mean = 0, sd = 0.5 ) + 
           (x4 - .24)^2*dnorm( x4 - .24, mean = 0, sd = 0.5 ) + 
           (x5 - .25)^2*dnorm( x5 - .25, mean = 0, sd = 0.5 ) + 
           (x6 - .26)^2*dnorm( x6 - .26, mean = 0, sd = 0.5 ))* 11.35
    
    
    
    # ### just for plotting purposes
    # best = which.max(Y)
    # image.plot(matrix(Y,mm), main = paste("Sines, X3 = ", round(mean(v),2), sep = "",
    #             ",  Y(x*) = ", round(max(Y),2)),
    #            xlab = "X1", ylab = "X2")
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # }
    
    return(Y)
    
  }# end sines
  
  if(name == 'twins'){
    
    #mm = 50; X = makepts(mm = mm, p = 6)
    # X = X[,c(2,3,4,5,1)] 
    
    x1 = X[,1] ; x2 = X[,2]; x3 = X[,3];
    x4 = X[,4] ; x5 = X[,5]; x6 = X[,6]
    
    
    # # library(rgl)
    # par(mfrow=c(3,2))
    # library(fields)
    # for( v in seq(0,1, length.out = 6)){
    #   x3 = x4 =x5 = x6 = v
    # library(MASS)
    ### x3: rotates the locations of these two bivariate densities
    ### x4: determines how high those density peaks are 
    ### x5: controls how wide the density peaks are
    ### x6: controls how much higher one of the peaks is 
    
    # width of density depends on x5; highest peaks at x5 = .7
    
    # locations of two center points, varying with X3, x4
    cents = .5+.3*matrix( c(  sin(1*pi*x3),
                              cos(1*pi*x3),
                              sin(1*pi*(x3 - 1)),
                              cos(1*pi*(x3 - 1))) , ncol = 4)
    
    ## their peaks depend on x4 as well 
    slope4 = 8- 1*(x4 -.7)^4
    slope4 = 8- 1*(x4 -.6)^4
    
    # width of density depends on  x5
    sd5= .25+ 2.8*( x5 - .7)^4
    sd5= .25+ 2.8*( x5 - .6)^4
    
    ### how much higher one peak is than the other [0, .10]
    # x6 = seq(0,1, length.out = 500)
    peaks = 1.15 - .6*(x6 - .8)^6
    
    #low zone
    low = (  3130 + 30*sin(6*pi*(x1 + x5 + x6 ))  )*
      dnorm( x1 - 1, sd = 3.5)*
      dnorm( x2 - 0, sd = 3.3)
    
    ## their mass restricted by x1, x2
    Y = (  peaks*slope4 )*dnorm( x1 -  cents[,1], sd = sd5)*
      dnorm( x2 -  cents[,2], sd = sd5)  +
      (  slope4 )*dnorm( x1 -  cents[,3], sd = sd5)*
      dnorm( x2 -  cents[,4], sd = sd5) + low - 27.70059 - 19.92553 - 10.3677
    
    
    # ### just for plotting purposes
    # best = which.max(Y)
    # image.plot(matrix(Y,mm), main = paste("Spin, X3 = ", round(mean(x3),2), sep = "",
    #             ",  Y(x*) = ", round(max(Y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # 
    # }
    
    return(Y)
    
  }# end spin
  
  if(name == 'toy'){
    
    #mm = 35; X = makepts(mm = mm, p = 6)
    # X = X[,c(2,3,4,5,1)] 
    
    x1 = X[,1] ; x2 = X[,2];
    # # library(rgl)
    # par(mfrow=c(3,2))
    # # # library(fields)
    # for( v in seq(0,1, length.out = 6)){
    #   x3 = x4 =x5 = x6 = v
    #x4 = v
    
    Y = 10*(x2)^2*pnorm( 10*(x1 - .4 ) ) + 
      sin(5*pi*( x2 - x1^2 ) - x1*x2 )*pnorm( 10*(.4 - x1 ) )
    
    #image.plot( matrix(Y, mm))
    
    
    # ### just for plotting purposes
    # best = which.max(Y)
    # image.plot(matrix(Y,mm), main = paste("Drum, X3 = ", round(mean(x3),2), sep = "",
    #             ",  Y(x*) = ", round(max(Y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # 
    # }
    
    return(Y)
    
  }# end toy
  
  
  if(name == 'toy2'){
    
    # mm = 65; X = makepts(mm = mm, p = 3)
    # X = X[,c(2,3,4,5,1)]
    
    x1 = X[,1] ; x2 = X[,2];
    # # library(rgl)
    # par(mfrow=c(3,2))
    # # # library(fields)
    # for( v in seq(0,1, length.out = 6)){
    #   x3 = x4 =x5 = x6 = v
    #x4 = v ; x3 = .5;
    
    Y = 
      110*(  26*sin(9*pi*( x2 - x1^2 ) - x1*x2 )*pnorm( 10*(.5 - x1 ) )*
               pnorm( 5*(x1 - .1 ) )*
               pnorm( 5*( x2 - .8) )*
               pnorm( 5*(.2 - x2))+
               (5-15*(x1-.3)^2) *pnorm( 20*(.05 - x2) )*pnorm(20*(x2 - .15)) +
               
               (5-15*(x2-.7)^2) *pnorm( 20*(.85 - x1) )*pnorm(20*(x1 - .95)) +
               0)/1.381694
    
    # 110/1.381694
    
    # (  26*sin(9*pi*( x2 - x1^2 ) - x1*x2 )*pnorm( 10*(.5 - x1 ) )*
    #     pnorm( 5*(x1 - .1 ) )*
    #     pnorm( 5*( x2 - .8) )*
    #     pnorm( 5*(.2 - x2))+
    #     (5-15*(x1-.3)^2) *pnorm( 20*(.05 - x2) )*pnorm(20*(x2 - .15)) +
    #     
    #     (5.05-15*(x2-.7)^2) *pnorm( 20*(.85 - x1) )*pnorm(20*(x1 - .95)) +
    #     0)*110/1.381694
    
    
    # image.plot( matrix(Y, mm)
    #             # , zlim = c(9.8,10)
    #             )
    # 
    # max(Y)
    # ### just for plotting purposes
    # best = which.max(Y)
    # image.plot(matrix(Y,mm), main = paste("Drum, X3 = ", round(mean(x3),2), sep = "",
    #             ",  Y(x*) = ", round(max(Y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # 
    # }
    
    return(Y)
    
  }# end toy
  
  if(name == 'drum'){
    
    #mm = 35; X = makepts(mm = mm, p = 6)
    # X = X[,c(2,3,4,5,1)] 
    
    x1 = X[,1] ; x2 = X[,2]; x3 = X[,3];
    x4 = X[,4] ; x5 = X[,5]; x6 = X[,6]
    
    
    # # library(rgl)
    # par(mfrow=c(3,2))
    # # # library(fields)
    # for( v in seq(0,1, length.out = 6)){
    #   x3 = x4 =x5 = x6 = v
    #x4 = v
    
    # library(MASS) # 10/3.655008
    ### x3: controls when the inner circle bulges up
    ### x4: middle circle bulge
    ### x5: outer circle bulge
    ### x6: affects both middle and outer circles
    inner = (6 - x3/4)*cos(  4*pi* (x3-.5)   )*(
      dnorm(   11*( (x1 -.5)^2 + (x2-.5)^2 + .25  )^2 )
    )     *(1 - 3*(x1-.3)^2)
    
    middl =   (1 + 2*x4)*sin(  2*pi* x4* (x5-.3)  )*(
      pnorm(     6*( (x1 -.5)^2 + (x2-.5)^2 - 0.13 ))
      *pnorm(   -8*( (x1 -.5)^2 + (x2-.5)^2 - 0.11 ))
    )*     (   1 + x4^2 + x5^2*(x2-.2)  )
    
    outer =    (1 - 2*x5)*cos(  2*pi* (x5) * (x4+.5)   )*(
      pnorm(     8*( (x1 -.5)^2 + (x2-.5)^2 - 0.2 )   )
    )*(       1 - x6^2 - x5^2*(x1+.2)   )
    
    
    Y = (inner + middl + outer) *(10/2.032078) - 4.4831
    
    #image.plot( matrix(Y, mm))
    
    
    # ### just for plotting purposes
    # best = which.max(Y)
    # image.plot(matrix(Y,mm), main = paste("Drum, X3 = ", round(mean(x3),2), sep = "",
    #             ",  Y(x*) = ", round(max(Y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # 
    # }
    
    return(Y)
    
  }# end drum
  
  
  if(name == 'beach'){
    
    # mm = 40; X = makepts(mm = mm, p = 6)
    # X = X[,c(2,3,4,5,1)]
    
    x1 = X[,1] ; x2 = X[,2]; x3 = X[,3];
    x4 = X[,4] ; x5 = X[,5]; x6 = X[,6]
    
    
    # # library(rgl)
    # par(mfrow=c(3,2))
    # # library(fields)
    # for( v in seq(0,1, length.out = 12)){
    #   x3 = x4 =x5 = x6 = v
    # library(MASS)
    ### x3: rotates the locations of these two bivariate densities
    ### x4: determines how high those density peaks are 
    ### x5: controls how wide the density peaks are
    ### x6: controls how much higher one of the peaks is 
    
    sdz = .2 + (2 + x6 + x5 - 1.5*x1)*(3 + x4 - x3 - x2)/12
    
    bumps = ( 
      
      5*sin(6*pi*x1*x6)*(x3^2 +1)-( x2^2 + 4 - x1*x2/(x3 - 7) + x4*(x5 - .3))^2*  
        cos( 4*pi*x1*x3^2 )^10*(x1*x2^2 - .5)*(x2*x6 - .5)*(x5 - .5)
      
    )*
      (  pnorm( 10*( .8 - x3 ), sd = sdz )
         *pnorm( 1*(  x1 - .1 ), sd = sdz )
         *pnorm( 1*( x2 - .1 ), sd = 2*sdz )
         # *pnorm( 1*( x3 - .1 ), sd = 2*sdz )
      )
    
    horiz = ( 10.5 - 30*(x1 - .3)^2  )*
      (  pnorm( 1*( .2 - x3  ), sd = sdz )
         *pnorm( 10*( .3 - x2 ), sd = sdz ) )
    
    vert = ( 10.5 - 30*(x2 - .85)^2  )* 
      (    pnorm( 5*( x3 - .8 ), sd = sdz )
           *pnorm( 10*( x1 - .8 ), sd = sdz ) )
    
    Y = bumps + horiz + vert -.97013 + .470418
    
    
    #   # ### just for plotting purposes
    #   best = which.max(Y)
    #   image.plot(matrix(Y,mm), main = paste("Spin, X3 = ", round(mean(x3),2), sep = "",
    #                                         ",  Y(x*) = ", round(max(Y),2)),
    #              xlab = "X1", ylab = "X2")
    #   
    #   points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    #   
    # }
    # 
    return(Y)
    
  }# end beach
  
  if(name == 'lava'){
    
    #mm = 50; X = makepts(mm = mm, p = 6)
    # X = X[,c(2,3,4,5,1)] 
    
    x1 = X[,1] ; x2 = X[,2]; x3 = X[,3];
    x4 = X[,4] ; x5 = X[,5]; x6 = X[,6]
    # library(rgl)
    
    
    # # library(rgl)
    # par(mfrow=c(2,2))
    # library(fields)
    # for( v in seq(0,1,.15)){
    #   x3 = x4 =x5 = x6 = v
    
    Y  = 8 + sin(3*pi*x1*x2 - pi*(x1-x2 -x3)) + 
      cos(4*pi*(x5*x6-x3) + 2*pi*(x2 - x5)*x2 ) + (.6+x3*(x1))*(x2-x3)^3
    # just for plotting purposes
    # best = which.max(Y)
    # image.plot(matrix(Y,mm), main = paste("Skate, X3 = ", mean(x3), sep = "",
    #             ",  Y(x*) = ", round(max(Y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # 
    # }
    
    
    # 15*(.8-x3)^2*(5 - exp(-5*(.3-x1))) +
    # 
    # 20*dnorm(3*(x2-.5))*  ## bottomright, scatter
    # dnorm(24*(x1-.5))*
    # (  1* atan( (x3 -.9)*25*pi )/(2*pi ) + .5  )
    return(Y)
    
  }# end lava
  
  if(name == 'skatebig'){
    #mm = 50; X = makepts(mm = mm, p = 8)
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3];
    x4 = X[,4]; x5 = X[,5]; x6 = X[,6];
    x7 = X[,7]; x8 = X[,8]; 
    
    # x3 =1
    # # # library(rgl)
    # par(mfrow=c(2,2))
    # for( v in seq(0,1,.33)){
    #   x3 = x4 =x5 =x6 =x7 = x8 = v
    #
    
    Y  = 6.69 + 
      ## TRUE PEAK
      dt(5*(x1-.4)*(x3), df = 5)/
      ( 10*(x2-.4)^2 + .25 ) + ## center bulge
      
      dt(50*(x2-.7)*x3, df = 2)/
      ( 20*(x1-.2)^4 + .25) + ##  lower horiz line
      
      dt(50*(x2-.9), df = 2)/
      ( 60*(x1-.2)^4 + .20) + ##  max horiz line
      
      # dt(1*(x2-.60), df = 24)/
      # (1*(x1-.15)^4 + .24) + ## bottom left bulge
      
      -30*dnorm(10*(x1-.8 - x5 + x8 - x6 + x7))*  ## bottomright, rising
      dnorm(2*(x2-.8 + x3 + x8))*
      (   atan( (3*x3 + x1 - .9 - x7 )*25*pi )/(2*pi ) + .5  + x4) -
      
      
      30*dnorm(10*(x1 + x2 + x7 -.4))*  ## bottomleft, diag
      dnorm(2*(x2-.8 + x3 + x4 - x5 + x6 ))*
      (  atan( (2*x3 + x2 + x7 + x8 - .9 )*25*pi )/(2*pi ) + .5  -x6)
    
    # 
    # library(fields)
    # # just for plotting purposes
    # best = which.max(y)
    # image.plot(matrix(y,mm), main = paste("Skate, X3 = ", mean(x3), sep = "",
    #             ",  Y(x*) = ", round(max(y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # }
    
    # 15*(.8-x3)^2*(5 - exp(-5*(.3-x1))) +
    # 
    # 20*dnorm(3*(x2-.5))*  ## bottomright, scatter
    # dnorm(24*(x1-.5))*
    # (  1* atan( (x3 -.9)*25*pi )/(2*pi ) + .5  )
    return(Y)
    
    
  }# end skatebig
  
  if(name == 'easy'){
    # mm = 50; X = makepts(mm = mm, p = 3)
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3]; # x3 =1
    # library(rgl)
    
    # par(mfrow=c(2,2))
    # for( v in seq(.25,1,.25)){
    #   x3 = v
    Y = 5 + (x3 > .8)*( 5*(x1-.4) ) + 
      -1*(x3 <= .8)*( 3*( x1 - .1)^2 + 5*(x2 - .5)^2 + 5*x3) 
    
    # library(fields)
    # # just for plotting purposes
    # best = which.max(y)
    # image.plot(matrix(y,mm), main = paste("Test, X3 = ", mean(x3), sep = "",
    #             ",  Y(x*) = ", round(max(y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # }
    return(Y)
  }# end easy
  
  
  if(name == 'cskate'){
    #mm = 50; X = makepts(mm = mm, p = 3)
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3]; # x3 =1
    # # library(rgl)
    # par(mfrow=c(2,2))
    # for( v in seq(0,1,.33)){
    #   x3 = v
    
    Y  = 6.69 + 
      ## TRUE PEAK
      dt(5*(x1-.4)*(x3), df = 5)/
      ( 10*(x2-.4)^2 + .25) + ## center bulge
      
      dt(50*(x2-.7)*x3, df = 2)/
      ( 20*(x1-.2)^4 + .25) + ##  lower horiz line
      
      dt(50*(x2-.9), df = 2)/
      ( 60*(x1-.2)^4 + .20) + ##  max horiz line
      
      # dt(1*(x2-.60), df = 24)/
      # (1*(x1-.15)^4 + .24) + ## bottom left bulge
      
      -30*dnorm(10*(x1-.8))*  ## bottomright, rising
      dnorm(2*(x2-.8 + x3 ))*
      (   atan( (3*x3 + x1 - .9 )*25*pi )/(2*pi ) + .5  ) -
      
      
      30*dnorm(10*(x1 + x2 -.4))*  ## bottomleft, diag
      dnorm(2*(x2-.8 + x3 ))*
      (  atan( (2*x3 + x2 - .9 )*25*pi )/(2*pi ) + .5  )
    
    # 15*(.8-x3)^2*(5 - exp(-5*(.3-x1))) +
    # 
    # 20*dnorm(3*(x2-.5))*  ## bottomright, scatter
    # dnorm(24*(x1-.5))*
    # (  1* atan( (x3 -.9)*25*pi )/(2*pi ) + .5  )
    
    # library(fields)
    ## just for plotting purposes
    # best = which.max(y)
    # image.plot(matrix(y,mm), main = paste("Skate, X3 = ", mean(x3), sep = "",
    #             ",  Y(x*) = ", round(max(y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # }
    # plot3d(z = y, x = x1, y = x2)# ;library(fields) ;library(rgl)
    # plot3d(z = y, x = x1, y = x3)
    # 
    # plot3d(z = y, x = x2, y = x3)
    
    
    
    # X[which.max(y),]
    
    
    return(Y)
    #return(y)
    
    # plot3d(x = x1, y = x2, z = y)
    #   plot3d(x = x1, y = x3, z = y)
    #  plot3d(x = x2, y = x3, z = y)
    
  }
  
  # if(name == 'horse'){
  #   
  #   
  #   x1 =  X[,1]; x2 = X[,2]
  #   
  #   Y = 10 - (10*(x1 - .37)^2 - 17*(x2 - .01)^2)*(2 - .5/(1+(x2-.5)^2))
  #   #image.plot(matrix(Y,30))
  #   return(Y)
  # }# end horse 
  
  if(name == 'lionking'){
    #### library(fields)
    #### mm = 60; X = makepts( mm = mm , p = 5)
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3];
    # # x4 = X[,4]; x5 = X[,5]; x6 = X[,6];
    # par(mfrow=c(2,2))
    # for( v in seq(0,1,.33)){
    #   x3  = v
    # 
    
    # upper bumps, involving all variables
    Y = 3.14749 + sin(  2*pi*(x1^2 - 2*x2*(1 + x3) ) )*
      ( pnorm( 30 *(x2 -.3))  + pnorm(30*(.8 - x2)) - 1 )*
      2*sin( 4*pi*x1 + 3*pi*(1+x3))  +
      
      ### Simba lion king when x3 near 0.2
      (  4 + 6*(x1) )*
      ((  pnorm( 30*(x2 - .0)) + pnorm(30*(.2 - x2))  ) - 1  )*
      ((  pnorm( 30*(x1 - .0)) + pnorm(30*(.6 - x1))  ) - 1  )*
      (   pnorm( 10*(.2 - x3))  ) +
      
      ### other area below simba lion king
      ### Simba lion king when x3 near 0.2
      (  1 - 8*(x1 + x2)^2 )*
      ((  pnorm( 40*(x2 - .0)) + pnorm(40*(.2 - x2))  ) - 1  )*
      ((  pnorm( 40*(x1 - .6)) + pnorm(40*(1 - x1))  ) - 1  )*
      (   pnorm( 10*(.2 - x3))  ) +
      
      #### unassuming, locally active region when x3 > .2
      .5*(  1 - sin( 8*pi*x1 + 7*pi*x2*x3) )*
      ((  pnorm( 30*(x2 - .0)) + pnorm(30*(.3 - x2))  ) - 1  )*
      (   pnorm( 8*(x3 - .3))  ) +
      
      #### deceptive maximum, when x2 > .8, x3 > .2, involving
      #### all variables
      (  5*cos( 2*(x2 + .5)*(x3 + .5)*(x1+.5)^2 ) - 
           .02*((1-x2)^2 + (1-x1)^2 + (1-x3)^2)   )*
      ( pnorm(5*(x2 - 1) + pnorm(10*(.5 - x3))))
    
    #     best = which.max(Y); X[best,]
    #     image.plot(matrix(Y,mm), main = paste("LionKing, X3 = ", mean(x3), sep = "",
    #                 ",  Y(x*) = ", round(max(Y),2)),
    #                xlab = "X1", ylab = "X2")
    # 
    #     points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # }
    
    return(Y)
    
    
    
  }# end 
  
  if(name == 'bar'){
    
    # mm = 50; X = makepts(mm = mm, p = 6)
    # X = X[,c(2,3,4,5,1)] 
    
    x1 = X[,1] ; x2 =  X[,2]; x3 =  X[,3];
    x4 = X[,4] ; x5 =  X[,5]; x6 =  X[,6]
    
    
    # # library(rgl)
    # par(mfrow=c(3,2), mar = c(3,3,3,3))
    # library(fields)
    # for( v in seq(0,1, length.out = 6)){
    #   x3 = x4 =x5 = x6 = v
    # ###### 
    
    ### rolls is an area involving x4,x5,x6,x1,x2
    ### activated for x3 = [0, 0.6]U[0.8,1]
    rolls = ( sin( 2*pi*   (x4 - .1) * (x5 - .8)          ) + 
                sin( 2*pi*   (x5 - .2) * ( x6 + .1 )*(x4- .2) ) + 
                sin( 2*pi*   (x6 - .9)               ) +
                cos( 2*pi * x6 * (x2 + .1) )
    )^2/3
    
    #bump1 is a quadratic in x2, peaking x3 = .4, bounded by x1 = [.3, .8]
    # we'll active this for x3 = [.6, .8]
    bump1 = 2 - 33*(x2 - .5)^2 *(      pnorm( 35*  (x2 - .4 ))
                                       +pnorm( 15*  (.8 - x2 ))
                                       -pnorm( 7*  (x1 - .4 ))
                                       *pnorm( 7*  (.7 - x1 ))
    )
    
    
    Y = (-1*rolls*(      pnorm(20*( x3 - .50  )) +pnorm(20*(   .4 - x3)) +
                           pnorm(20*( x3 - .8 )) *pnorm(20*(    1 - x3)))  +
           8 * bump1  * pnorm(40*( x3 - .42)) *pnorm(40*(  .82 - x3)) +
           0) - 4*x5*pnorm( 20*(x2 - .4)) - 6
    
    # ### just for plotting purposes
    # best = which.max(Y)
    # image.plot(matrix(Y,mm), main = paste("Bar, X3 = ", round(mean(x3),2), sep = "",
    #             ",  Y(x*) = ", round(max(Y),2)),
    #            xlab = "X1", ylab = "X2"
    #            # , zlim = c(-2,2)
    #            )
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # 
    # }
    
    return(Y)
    
  }# end bar
  
  
  if(name == 'simba'){
    #### library(fields)
    #### mm = 40; X = makepts( mm = mm , p = 6)
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3];
    x4 = X[,4]; x5 = X[,5]; x6 = X[,6];
    # par(mfrow=c(3,2))
    # for( v in seq(0,0.3, length.out = 6)){
    #   x3  =   v
    # x4 = x5 = x6 = 0.1
    #upper bumps, involving all variables
    Y = 3.14749 + sin(  2*pi*(x1^2 - 2*x2*(1 + x3) ) )*
      ( pnorm( 30 *(x2 -.3))  + pnorm(30*(.8 - x2)) - 1 )*
      2*sin( 4*pi*x1 + 3*pi*(1+x3) + 2*pi*(x4 + x5) + 3*pi*(1 + x6))  +
      
      ### Simba lion king when x3 near 0.2
      (  4 + 6*(x1) )*
      ((  pnorm( 30*(x2 - .0)) + pnorm(30*(.2 - x2))  ) - 1  )*
      ((  pnorm( 30*(x1 - .0)) + pnorm(30*(.6 - x1))  ) - 1  )*
      (   pnorm( 10*(.2 - x3))  ) +
      
      ### other area below simba lion king
      ### Simba lion king when x3 near 0.2
      (  1 - 8*(x1 + x2 - x4 - x5 - x6)^2 )*
      ((  pnorm( 40*(x2 - .0)) + pnorm(40*(.2 - x2))  ) - 1  )*
      ((  pnorm( 40*(x1 - .6)) + pnorm(40*(1 - x1))  ) - 1  )*
      (   pnorm( 10*(.2 - x3))  ) +
      
      #### unassuming, locally active region when x3 > .2
      .5*(  1 - sin( 8*pi*x1 + 7*pi*x2*x3 - 4*pi*x4*x5*x6) )*
      ((  pnorm( 30*(x2 - .0)) + pnorm(30*(.3 - x2))  ) - 1  )*
      (   pnorm( 8*(x3 - .3))  ) +
      
      #### deceptive maximum, when x2 > .8, x3 > .2, involving
      #### all variables
      (  5*cos( 2*(x2 + .5)*(-x4 + .5)*(-x5+.5)^2 )*(-x6 - .5) - 
           .02*((1-x2)^2 + 
                  (1-x1)^2 + 
                  (1-x3  - .3*x4)^2  + 
                  (1-x5  + .5*x4)^2 + 
                  (.8-x6 - .4*x4)^2 )   )*
      ( pnorm(5*(x2 - 1) + pnorm(10*(.5 - x3))))
    # # 
    #     best = which.max(Y); X[best,]
    #     image.plot(matrix(Y,mm), main = paste("Simba, X3 = ", mean(x3), sep = "",
    #                 ",  f(x*) = ", round(max(Y),2)),
    #                xlab = "X1", ylab = "X2")
    # 
    #     points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # }
    
    #     return(Y)
    
    
    
  }# end 
  
  
  if(name == 'dreambig'){
    # library(fields); P = 10; 
    # mm = 50; X = makepts(mm = mm , p = 10)
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3];
    x4 = X[,4]; x5 = X[,5]; x6 = X[,6];
    # x7 = X[,7]; x8 = X[,8]; #x9 = X[,9]; x10 = X[,10]
    
    # par(mfrow=c(2,2))
    # for( v in seq(0,1,.33)){
    #   x3 = x4 =x5=x6=x7=x8=x9=x10 = v
    
    Y = -20.72247 +
      ( 5  + 30*x1 + sin(8*pi*x1))*  ### top right highest
      (
        .1 + pnorm( 55*(x2-.8) )*
          pnorm( 25*( x3-.0) )*
          pnorm( 85*(.9-x1))
      ) +
      
      ( -20- 3*cos( 52*pi*(x3) ^2 ) - ### some boxes ?? 
          3*cos( 4*pi*x2 ) )*
      pnorm( 55*(x1-.8 )  ) +
      (-50 - 3*(x2 -.0)^2)*
      dnorm(25*(x2-.8    - .08*(- x6 -x5 - x4 - x3 ) ) ) +
      
      pnorm(5*(.6 - x2 ))*   ### bottom diagonals
      pnorm(5*(.6 - x1))*
      (
        -15*sin( 
          52*pi*(x3) + 
            4*pi*x2 + 
            4*pi*x1 - 
            2*x4 -
            5*pi*(x5-.2) +
            3*x6 
        )  +
          
          5*cos(
            4*pi*x4 + 2*(x2-.2)+ 4*(x5 - .5)
          )*x4 +
          
          3*sin( - x5 - x6 - x4 )*(2-x3^2)
        
        -3*(x4-x3-x5-x6)^2
      )
    # 
    #     best = which.max(Y); X[best,]
    #     image.plot(matrix(Y,mm), main = paste("Dream, X3 = ", mean(x3), sep = "",
    #                 ",  Y(x*) = ", round(max(Y),2)),
    #                xlab = "X1", ylab = "X2")
    # 
    #     points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    #      }
    
  }# end dreambig
  
  if(name == 'cdream'){
    # library(fields)
    # mm = 120; X = makepts(mm = mm , p = 3)
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3];
    # x3 = .3
    # par(mfrow=c(2,2))
    # for( v in seq(0,1,.33)){
    #   x3 = v
    Y = -20.72247 +
      ( 5  + 30*x1 + sin(8*pi*x1))*  ### top right highest
      (
        .1 + pnorm( 55*(x2-.8) )*
          pnorm( 25*( x3-.0) )*
          pnorm( 85*(.9-x1))
      ) +
      
      # ( -3 - 74*(x1 - .8)^2     #### 
    #      - 24*(x2 - .2)^2
    #      - 14*(x3 - .0)^2   )*
    # (
    #   .1+ pnorm( 55*(.8-x2))*
    #       pnorm( 15*(.0-x3))*
    #       pnorm( 55*( x1-.8))
    #    ) +
    
    (-20- 3*cos( 52*pi*(x3) ^2 ) - ### some boxes ?? 
       3*cos( 4*pi*x2 ) )*
      pnorm( 55*(x1-.8)) +
      (-50 - 3*(x2 -.0)^2)*
      dnorm(25*(x2-.8)) +
      
      pnorm(5*(.6 - x2))*   ### bottom diagonals
      pnorm(5*(.6 - x1))*
      (
        -15*sin( 52*pi*(x3) + 4*pi*x2 + 4*pi*x1)
        
      )
    
    
    # ## just for plotting purposes
    # best = which.max(Y); X[best,]
    # image.plot(matrix(Y,mm), main = paste("Dream, X3 = ", mean(x3), sep = "",
    #             ",  Y(x*) = ", round(max(Y),2)),
    #            xlab = "X1", ylab = "X2")
    # 
    # points(x1[best], x2[best] , pch = "*", cex = 2, col = 'white')
    # }
    # library(rgl)
    # plot3d(z = Y, x= x2, y = x1)
    
    return(Y)
  }
  
  if(name == 'dream'){
    
    
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3];
    
    box = (  x1 > 0 & x1 <.5 &
               x2 >.5 & x2 < 1 & 
               x3 >.5 & x3 < 1  )
    
    bad = (x1 > .7 & x1 <= 1)
    Y = (-15 + 30*x1 + sin(8*pi*x1))*box + 
      (-3 - 14*(x1 - .9)^2 
       - 34*(x2 - .2)^2 
       - 14*(x3 - .2)^2
      )*(!box & !bad) + 
      
      (-20-3*sin(2*pi*x3^2) - 3*cos(4*pi*x2))*bad
    
    # plot3d(x = x1, y = x2, z = Y)
    #   plot3d(x = x1, y = x3, z = Y)
    #  plot3d(x = x2, y = x3, z = Y)
    #
    
  }# end three
  
  
  if(name == 'bubble'){
    # nnn = 4500
    # X = matrix(runif(nnn*2),nnn,2)
    x1 = 10*X[,1] ; x2 = 10*X[,2];
    left = (x1  >  4.6 & x1 < 5) 
    right = (x1 >= 5 & x1 < 6)
    bumps = matrix( c( #1,2,1,4,1,5,1.6,6,1,7,1,8,
      #2,1,2,2,2,3.5,2.3,5,2.8,6,2,8,
      
      # 7,1,7,4,7.5,5,7,6,7,7,7,9,
      8,1,8,2,8,3,8,5.5,8,6,8,8,
      9,5,9,9,9,6,9,1,9,2,9,3),ncol = 2, byrow = T)
    
    temp = 0 
    for(i in 1:nrow(bumps)) temp = temp + 1/( .1+ (x1 - bumps[i,1])^2 +
                                                (x2 - bumps[i,2])^2 )
    Y = temp + (3*x1)*left + (3*5*2 - 3*x1)*right
    temp =      (12 - .1*(x2 - 3)^2)*(x1 < 3 )
    temp[temp< -3] = -3 
    Y = Y + temp 
    
    #quilt.plot(z = Y, x = x1, y = x2)
    
    
  }#end bubble
  
  if(name == 'cross'){
    x1 = 20*X[,1]-10 ; x2 = 20*X[,2] - 10 
    
    Y = .0001*(
      abs( sin(x1)*sin(x2)*exp( 
        abs(
          100 - sqrt( x1^2 + x2^2)/pi 
        )
      )
      ) + 1
    )^.1
    
  }# end cross
  
  if(name == 'bumps'){
    
    box1 = (  X[,1] <= .5 & X[,2] <= .5  )
    box2 = (  X[,1] <= .5 & X[,2] > .5   )
    box3 = (  X[,1] >  .5 & X[,2] <= .5  )
    box4 = (  X[,1] >  .5 & X[,2] > .5)
    
    Y = 
      ( 0.99 - 55*(X[,3] - .3 )^2 - 55*(X[,4 ] - .4)^2  )*box1 + 
      ( 1.02 - 25*(X[,5] - .5 )^2 - 45*(X[,6 ] - .6)^2  )*box2 + 
      ( 1.00 - 55*(X[,7] - .7 )^2 - 55*(X[,8 ] - .8)^2  )*box3 + 
      ( 1.01 - 25*(X[,9] - .9 )^2 - 45*(X[,10] - 1.0)^2  )*box4 +
      (-1)*(!box1 & !box2 & !box3 & !box4)
    
    #  plot3d( z= Y, x = X[,3], y = X[,4])
  } # end bumps
  
  if(name == 'boxbox'){
    #X[,1] = .8 ; X[,2] = .1
    # nnn = 7650; ppp = 10;
    # X = matrix(runif(nnn*ppp),nnn,ppp)
    
    
    box1 = ( X[,1] <= .25               & X[,2] <= .25 )
    box2 = ( X[,1] <= .25 & X[,2] > .25 & X[,2] <= .85 )
    box3 = ( X[,1] <= .25               & X[,2] >  .85 )
    
    box4 = ( X[,1] >  .25 & X[,1] <= .85               & X[,2] <=  .25  )
    box5 = ( X[,1] >  .25 & X[,1] <= .85 & X[,2] > .25 & X[,2] <=  .85  )
    box6 = ( X[,1] >  .25 & X[,1] <= .85               & X[,2] >   .85  )
    
    box7 = ( X[,1] >  .85                & X[,2] <=  .25 )
    box8 = ( X[,1] >  .85  & X[,2] > .25 & X[,2] <=  .85 )
    box9 = ( X[,1] >  .85                & X[,2] >   .85 )
    
    Y =          
      (14.9 - 45*( X[,7] - .5)^2 
       - 25*( X[,6] - .3)^2) *box1 + 
      (14.5 - 58*(X[,1])^2 
       - (X[,2])^2 
       - (X[,3])^2  )*box2 + 
      (12 - cos(4*pi*X[,4]) 
       - cos(X[,5]) 
       - cos(3*pi*X[,6])
       - cos(X[,7]-.5)^2 
       - sin(8*pi*X[,8]) )*box3 + 
      (15.10 - 8*X[,3]^2 
       - 20*X[,8]^2
       - 38*X[,6]^2 )*box4 + 
      (15.15    - 150*(X[,1]-.5)^2 
       - 50*(X[,4] - .2)^2 )*box5 + 
      (15.05 - X[,8]^2 
       - (X[,5]-.2)^2 )*box6 +                        #
      (15.20     - 58*(X[,4]-.95)^2 
       -28*(X[,7] - .11)^2 )*box7 +
      (9 + cos(4*pi*X[,5] 
               - X[,4]) )*box8 +
      (15.18 - 68*(X[,1]-.3)^2 
       - 65*(X[,2]-.3)^2 )*box9 +
      (-5 - 4*cos(8*pi*X[,7]) 
       - cos(8*pi*X[,8]) 
       + cos(8*pi*X[,3]  ))*
      ( !box1 & !box2 & !box3 & !box4   & 
          !box5 & !box6 & !box7 & !box8 & !box9  )
    
    
    # plot(Y[Y> 0]~X[ Y > 0 ,1])
    # plot(Y[Y> 14]~X[ Y > 14 ,4])
    
    # plot3d(z  = Y, x = X[,1], y = X[,2])
    # plot3d(z  = Y, x = X[,4], y = X[,7])
    # plot3d(z  = Y, x = X[,1], y = X[,4])
    # plot3d(z  = Y, x = X[,2], y = X[,4])
    # plot3d(z  = Y, x = X[,3], y = X[,6])
    
  } #end boxes
  
  
  
  if(name == 'boxes'){
    #X[,1] = .8 ; X[,2] = .1
    # nnn = 7650; ppp = 11;
    # X = matrix(runif(nnn*ppp),nnn,ppp)
    
    
    box1 = ( X[,1] <= .25               & X[,2] <= .25 & X[,7] <= .3 & X[,5] < .5)
    box2 = ( X[,1] <= .25 & X[,2] > .25 & X[,2] <= .75 & X[,7] <= .3 & X[,5] < .5)
    box3 = ( X[,1] <= .25               & X[,2] >  .75 & X[,7] <= .3 & X[,5] < .5)
    
    box4 = ( X[,1] >  .25 & X[,1] <= .75               & X[,2] <=  .25  & X[,4] > .8 & X[,5] >= .5)
    box5 = ( X[,1] >  .25 & X[,1] <= .75 & X[,2] > .25 & X[,2] <=  .75  & X[,4] > .8 & X[,5] >= .5)
    box6 = ( X[,1] >  .25 & X[,1] <= .75               & X[,2] >   .75  & X[,4] > .8 & X[,5] >= .5)
    
    box7 = ( X[,1] >  .75                & X[,2] <=  .25 & X[,5] > .3 & X[,4] <= .8 & X[,6] >= .8)
    box8 = ( X[,1] >  .75  & X[,2] > .25 & X[,2] <=  .75 & X[,5] > .3 & X[,4] <= .8 & X[,6] >= .8)
    box9 = ( X[,1] >  .75                & X[,2] >   .75 & X[,5] > .3 & X[,4] <= .8 & X[,6] >= .8)
    
    Y = # x9 
      (14.9 - 45*( X[,9] - .5)^2 )*box1 + 
      # x1, x2, x3
      (14.5 - 58*(X[,1])^2 - (X[,2])^2 - (X[,3])^2  )*box2 + 
      # x4 - x8
      (-8 - cos(4*pi*X[,4]) - cos(X[,5]) -cos(3*pi*X[,6])
       - cos(X[,7]-.5)^2 + sin(8*pi*X[,8]) )*box3 + 
      # x9, x10, x6
      (12 - 8*X[,9]^2 - 20*X[,8]^2 - 38*X[,6]^2 )*box4 + 
      # x1 x4
      (15 - 150*(X[,1]-.5)^2 - 50*(X[,4] - .9)^2 )*box5 + 
      # x8 x9 
      (14 - X[,8]^2 - (X[,9]-.2)^2 )*box6 + 
      # x4  
      (15.2 - 58*(X[,4]-.5)^2  )*box7 +
      # x5 x4
      (9 + cos(4*pi*X[,5] - X[,4]) )*box8 +
      # x1 x2
      (15.1 - 68*(X[,1]-.3)^2 - 65*(X[,2]-.3)^2 )*box9 +
      # x3 x6 x7 x9 
      (-5 +   4*cos(8*pi*X[,7]) + cos(8*pi*X[,8]) + 
         cos(8*pi*X[,3] + 8*pi*X[,9] ))*(
           !box1 & !box2 & !box3 & !box4   & 
             !box5 & !box6 & !box7 & !box8 & !box9  )
    
    #Y[Y < -200] = -200
    # plot(Y[Y> 0]~X[ Y > 0 ,1])
    # plot(Y[Y> 14]~X[ Y > 14 ,4])
    
    
    
    
    
    # plot3d(z  = Y, x = X[,1], y = X[,2])
    # plot3d(z  = Y, x = X[,6], y = X[,4])
    # plot3d(z  = Y, x = X[,1], y = X[,4])
    # plot3d(z  = Y, x = X[,2], y = X[,4])
    # plot3d(z  = Y, x = X[,6], y = X[,7])
    
  } #end boxes
  
  
  
  
  if(name == 'nonlin'){
    #X[,1] = .5
    # condition = (  X[,1] < 1 & X[,1] > 0 & X[,2] < 1 & X[,2] > 0 )
    x1 = X[,1]; x2 = X[,2];
    
    Y = (1 - .5*cos( x1*x2*4*pi ))*(1 + sin( 2*pi*x1*(2-x2) ) ) + 
      cos(2*pi*x2 - x1*5*pi) *
      ( 1 - x1^(1 + x1) - x2^(1 + x2 ) )
    # *(condition) + 
    # .5*sin(3*X[,1] + X[,2])*(!condition)
    
    # plot3d(z  = Y, x = X[,1], y = X[,2])
    # plot3d(z  = Y, x = X[,p-1], y = X[,3])
    
  } #end nonlin
  
  
  if(name == 'pointy'){
    
    condition = (X[,1] <= .45 & X[,1] > .35 & X[,2] < .9 & X[,2] > .1 ) 
    
    p = ncol(X) ; Y = 0
    
    for(j in 1:p) Y = Y +( -(12 )*(X[,j] - .5  )^2)*(!condition)
    Y = Y + (10 - 58*(X[,2]-.4)^2)*( X[,2] < .5 & X[,2] > .3 &
                                       !condition)
    Y = Y + (-15 - 28*(X[,p]-.2)^2)*( X[,p] < .5 & X[,p] > .1 &
                                        !condition)
    Y = Y + (15 - 5458*(X[,1]-.4)^2)*(condition) 
    
    return(Y)
    
    #  plot3d(z  = Y, x = X[,1], y = X[,2])
    # plot3d(z  = Y, x = X[,p-1], y = X[,3])
    
  } #end pointy
  
  if(name == 'heidi2'){
    ## as in, High D, many dimensions
    ## all are active, in a bowl, 
    ## but the GLOBAL max is in a small local region
    ## at ( .43, ~.3, ~.3, ~.5 , ~.55 )
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3]; x4 = X[,4]; x5 = X[,5]
    
    
    condition = (      .4 < x1 & x1 < .45 & 
                         .4 < x2 & x2 < .45 &
                         .4 < x3 & x3 < .45 &
                         .4 < x4 & x4 < .45 &
                         .4 < x5 & x5 < .45 )
    
    
    bowl = -1*( 13*(x1 -.4)^2 + 12*(x2 -.4)^2 + 
                  14*(x3 -.4)^2 + 15*(x4 -.4)^2 + 13*(x5 -.4)^2  )*(!condition)
    
    high = (3 - 178*(x1-.43)^2)*( condition )
    
    Y = bowl + high ;
    
    
    # plot3d( z = Y, x = x1, y = x5  )
    #  plot3d( z = Y, x = x2, y = x4  )
    # plot3d( z = Y, x = x3, y = x5)
    
  }
  
  
  if(name == 'heidi'){
    ## as in, High D, many dimensions
    ## 5 active, but region of max is local to x1
    ## X = matrix(runif(nnn*5),nnn,5)
    x1 = X[,1]; x2 = X[,2]; x3 = X[,3]; x4 = X[,4]; 
    
    ### coming up with a few particular subregions
    ### so that "locally active" is evident
    ### true max is at {.4, (.3,.6), <.8, <.8 , <.8}
    
    box1 = (x1 >= 0  & x1 < .3 ) 
    box2 = (x1 >= .3 & x1 < .6 )
    box3 = (x1 >= .6 & x1 < .8 )
    box4 = (x1 >= .8 & x1 <= 1 )
    
    Y = box1*(  9.6  - 100*(x1 - .1)^2   ) + 
      box2*(  9.9 - 100*(x2 - .2)^2   ) + 
      box3*(  9.8 - 100*(x3 - .3)^2   ) + 
      box4*(  9.7 - 100*(x4 - .4)^2   )
    
    
    # plot3d( z = Y, x = x2, y = x4  )
    # plot3d( z = Y, x = x3, y = x1)
    # plot3d( z = Y, x = x1, y = x4  )
    
  }
  
  if(name == 'country'){
    
    x2 = X[,2]; x1 = X[,1]
    houseL = 5*x2 * (x1 > .5 & x1 < .7   & x2 > .2 & x2 < .4)
    houseR = (4-5*x2)* (x1 > .5 & x1 < .7 & x2 >= .4 & x2 <= .6)
    bumps = .2*(1*cos(5*x1)^2  - 1*sin(8*x2) )
    Y = x1
    
    Y = houseL + houseR + bumps*(x1 < .2 | x1 > .8 ) + 
      -bumps*(x2 <.1 | x2 > .9) + 
      -2*((x1 - .3)^2 + (x2 - .3)^2)*(x1 < .2 | x1 > .7) + 
      (-5*x2 )*(x2 <.2 & x2 > .1 & x1 > .3 & x1 < .5) - 
      5*x2*(x1 > .8) - 3*abs(cos(8*x1 + 5*x2))*(x1 < .2 )
    #  plot3d(z = Y, x = x1, y = x2)
    
  }
  
  
  if(name == "hartmann6"){
    ## ----------------------------------------------------- ##
    ## code: https://www.sfu.ca/~ssurjano/Code/hart6r.html   ##
    ## ----------------------------------------------------- ##
    ## --- scaled to be from ~0 to 10
    alpha <- c(1.0, 1.2, 3.0, 3.2)
    
    A     <- matrix( c(10, 3, 17, 3.5, 1.7, 8,
                       0.05, 10, 17, 0.1, 8, 14,
                       3, 3.5, 1.7, 10, 17, 8,
                       17, 8, 0.05, 10, 0.1, 14), ncol = 6, byrow  = T)
    
    P    <- 10^(-4) *matrix( 
      c(1312, 1696, 5569, 124, 8283, 5886,
        2329, 4135, 8307, 3736, 1004, 9991,
        2348, 1451, 3522, 2883, 3047, 6650,
        4047, 8828, 8732, 5743, 1091, 381)
      ,ncol =  6, byrow=TRUE)
    
    xxmat <- matrix( rep( X[,1:6] , each = 4)
                     , ncol =  6, byrow=F)
    
    rP    <- matrix(rep(t(P), times = nrow(X) ), ncol = 6, byrow = T)
    rA    <- matrix(rep(t(A), times = nrow(X) ), ncol = 6, byrow = T)
    
    inner <- matrix( rowSums( rA * (xxmat - rP)^2  ), byrow = T, ncol = 4)
    outer <- exp(-inner) %*% alpha
    y     <- c((outer - 3.6*1e-7)/.332071)
    return(y)
    
    
  }#end 
  
  if(name == 'ackley'){
    # X = makepts( mm = 420, p = 6)
    ### -- domain is [-32,32]
    ### -- max is on scaled = 0,0,0...
    ####--requiring six dimension!
    P  = 6
    Xs = X[,1:P]*64-32;  a = 20; b = 1/5; c = 2*pi
    
    
    ####--
    
    Y = -1*(
      -a * exp( -b * sqrt( 1/P * rowSums( Xs^2  )   ))
      -exp(  1/P * rowSums(  cos( c*Xs) ) ) 
      + a + exp(1) )
    Y = (Y+22.6516)/2.265165
    
  }
  
  if(name == 'gold'){
    ### domain is on X = [-2,2]
    ### Goldstein-Price
    x1 = X[,1]*4 -2; x2 = X[,2]*4 -2;
    
    Y = -1*(
      (1+ ( x1 + x2 +1 )^2*
         (19 - 14*x1 + 3*x1^2 - 14*x2 + 6*x1*x2 + 3*x2^2))*
        (30 + (2*x1 - 3*x2)^2*
           ( 18 - 32*x1 + 12*x1^2 + 48*x2 - 36*x1*x2 + 27*x2^2)
        )
      
    )
  }
  
  
  if(name == 'micha'){
    ### domain is on X = [0,pi]
    ### Michalewicz
    ### mm = 250; X = makepts(mm = mm, p = 6)
    # P should be the original dimensional problem
    m = 10;    Y = 0
    
    for(j in 1:P) Y = Y - 
        ( -sin( X[,j]*pi )*sin( j *(X[,j]*pi)^2 / pi )^(2*m)   )
    
    
    
    
    
  } # end michalewicz
  
  if(name == 'dixon'){
    ### domain is X = [-10,10]
    ### scaled to be from 0 to 10 (finding a maximum)
    # X = makepts(mm = 12, p = 6)
    # P = 6
    Xs = X*20-10 
    Y  = -(Xs[,1]-1)^2;
    for(j in 2:P) Y = Y - j*(2*Xs[,j]^2 - Xs[,j-1])^2
    
    ## -scaling to be from 0 to 10
    Y = (Y+ 9*10e4)/(9*10e3)
    
  }# end dixon-price function
  
  
  if(name == 'micha6'){
    ### domain is on X = [0,pi]
    ### Michalewicz
    ### P = 6; mm = 660; X = makepts(mm = mm, p = 6)
    # P should be the original dimensional problem
    m = 10;    Y = 0; 
    
    for(j in 1:6) Y = Y - 
        ( -sin( X[,j]*pi )*sin( j *(X[,j]*pi)^2 / pi )^(2*m)   )
    Y = Y/.4406
    
    
  } # end michalewicz 5 dimension
  
  
  if(name == 'branin'){
    ### domain is on X = [c(-5,10) , c(0,15)]
    ###
    
    x1 = X[,1]*15 -5; x2 = X[,2]*15;
    
    Y = -1*(
      (x2 - 5.1*x1^2/(4*pi^2) + 5*x1/pi - 6)^2 +
        10*(1 - 1/(8*pi))*cos(x1)+ 10
    )
    
  }
  
  
  
  if(name == 'skate'){
    ### ### uses just two dimensions
    q1 = 1.25-3*floor( abs(X[,1]-.2)*50)/20
    q2 = 1.25-3*floor( abs(X[,2]-.8)*50)/15
    q3 = -3 +(11*(X[,1]-.8)^2 + 11*(X[,2]-.2)^2)
    
    Y =  (X[,1] < .5 & X[,2] < .5 & X[,1] >= 0 & X[,2] >= 0 )*q1 + 
      (X[,1] > .5 & X[,2] > .5 & X[,1] <= 2 & X[,2] <= 2)*q2 +
      (X[,1] > .5 & X[,2] < .5 & X[,1] <= 2 & X[,2] >= 0)*q3 +
      (X[,1] < .5 & X[,2] > .5 & X[,1] >= 0 & X[,2] <= 2)*(0.1)
    
    Y = Y/1.25*10
  }
  
  
  if(name == 'griewank'){
    ### domain is on X = [-600,600]
    ### X = maximinLHS( 620, 6); X = ptss
    # P should be the original dimensional problem
    Xs = X*1200 - 600;
    
    Y = -1*(
      
      rowSums( Xs^2 )/4000 - 
        cos( Xs[,1]/sqrt(1) )*
        cos( Xs[,2]/sqrt(2) )*
        cos( Xs[,3]/sqrt(3) )*
        cos( Xs[,4]/sqrt(4) )*
        cos( Xs[,5]/sqrt(5) )*
        cos( Xs[,6]/sqrt(6) ) + 1
      
    )
    
    Y = (Y + 1351)/135.1
    
    return(Y)
    
  } # end holder
  
  
  if(name == 'dropwave'){
    ### domain is on X = [-10,10]
    ### mm = 50; X = makepts(mm = mm, p = 2)
    # P should be the original dimensional problem
    x1 = (X[,1]*10.24)-5.12 ; x2 = (X[,2]*10.24)-5.12
    
    Y = (1 + cos(12*sqrt(x1^2 + x2^2 ) ))/(
      .5*(x1^2 + x2^2)  + 2     )*10
    
    return(Y)
    
    
  } # end dropwave
  
  if(name == 'holder'){
    ### domain is on X = [-10,10]
    ### mm = 250; X = makepts(mm = mm, p = 2)
    # P should be the original dimensional problem
    x1 = (X[,1]*20)-10 ; x2 = (X[,2]*20)-10
    
    Y = abs(
      sin(x1)*cos(x2)*exp(
        abs(
          1 - sqrt(x1^2 + x2^2)/pi
        )
      )
    )
    
    Y = Y/1.920845
    
  } # end holder
  
  if(name == 'flat'){
    ### ### uses just two dimensions
    Y = (1e-6)*X[,1] + (1e-6)*X[,2] + rnorm(length(X[,1]), 0, .0001)
  }
  
  if(name == 'cliff'){
    ### ### uses just two dimensions
    q1 = (1e-6)*X[,1] + (1e-6)*X[,2] + rnorm(length(X[,1]), 0, .0001)
    q2 = 1-2*X[,1]
    
    Y = (X[,1] < .5 & X[,2] < .5)*q1 + 
      (X[,1] >= .5 & X[,2] >= .5 )*q2
  }
  
  if(name == 'bowl'){
    ### ### uses just two dimensions
    Y = 2 + (-2*(X[,1]-.2)^2 -3*(X[,2]-.5)^2)
  }
  
  if(name == 'point'){
    ### ### uses just two dimensions
    Y = (X[,1] < .8 & X[,1] > .6 & 
           X[,2] < .8 & X[,2] > .6 )*5
  }
  
  if(name == 'waves'){
    
    # N = 3e3;
    # X = matrix(runif(N*p),N,p)
    x1 = 3*X[,1] - 1; x2 = 5*X[,2] + .5
    Y = .05*(x1 - 13*sin(x2*4 - x1*cos(abs(x2))) - 1.5)^2 + 
      .01*(x1*x2 - 5*cos(x1*3 + x2*sin(-x1)  - 1.6 ))^2
    
    
    # quilt.plot(z = Y,X[,1],X[,2])
    
    
    
  }
  
  
  if(name == 'standard'){
    
    m = 0.5
    lft = -m+3*(X[,1]+.2)
    rgt = .1 - 13*(X[,2] - .5)^2
    Y = (lft)*( X[,1]  <= m) + 
      2*( X[,1] > m) + rgt
    
  }
  
  if(name == 'pyramid'){
    
    q1 = 3*X[,1]
    q2 = -3*X[,1]
    q3 = -3*X[,2]
    Y = (X[,1] < .5 & X[,2] < .8 & X[,2] > .2)*q1 + 
      (X[,1] < .5 & X[,2] > .8 )*q3 + 
      (X[,1] < .5 & X[,2] > .8 )*q3 + 
      (X[,1] < .5 & X[,2] < .2 )*q3 + 
      (X[,1] > .5 )*q2
    
  }
  
  if(name == 'stalagmite'){
    pt  = runif(90,0.2,1)
    pt2 = runif(90,.2,1)
    ptt = cbind(pt-runif(90)/8, pt2-runif(90)/8)
    Y  = 0
    for(i in 1:90) Y = Y + rnorm(1,1,1)*(X[,1] > ptt[i,1] &  
                                           X[,1] < pt[i] & 
                                           X[,2] > ptt[i,2] &
                                           X[,2] < pt2[i]  )
    
    
  }
  
  if(name == 'rough'){
    Y = #(X[,1] < .4 & X[,2] < .4 )*
      (
        ( -27*(X[,1]-.2)^2 - 13*(X[,2]-.21)^2  + 1) +
          #   (X[,1] > .6 & X[,2] > .6)*
          ( -3*(X[,1]-.5 )^2 + -3*(X[,2] -.5 )^2 + 1 ) + 
          # (X[,1] > .1 & X[,1] < .7 & X[,2] > .1 & X[,2] < .7)*
          -(4*sin(rpois(length(X[,1]),18)*X[,1]) + 4*sin(17*X[,2]+ X[,1]^2 )    )
      )*( (X[,1] + X[,2] <= 2)*(X[,1] + X[,2] >= 0) )
    
  }
  
  
  if(name == 'one'){
    
    Y = 3*X[,1]*(X[,1] < .5) +
      3/2*(X[,1] >= .5 & X[,1] <.9) + 
      3*.9*(X[,1] >= .9)
    
  }
  
  if(name == 'onebowl'){
    
    Y = -16*(1+2.5*sin(8*X[,1]))*( X[,1] - .5 )^2 
  }
  
  if(name == 'saddle'){
    Y = 15*(X[,1] - .5)^2 - 15*(X[,2]- .3)^2
    
  }
  
  
  if(name == 'twobowl'){
    
    Y = -15*( X[,1] - .3 )^2*(X[,1] < .5) + 
      -18*( X[,1] - .7 )^2*(X[,1] >= .5)
    
    #plot(Y~X)
    
  }
  
  if(name == 'linear'){
    
    Y = slope*X[,1]*(X[,1] >= 0 &  X[,1] <= 1) 
    
    #plot(Y~X)
    
  }
  
  
  if(name == 's'){
    x1 = 3*(X[,1] -.5)
    Y =  (-21*x1^3 + 1*(x1)^2 + 22*x1 - 11.328 )*(
      X[,1] > .2  & X[,1] < .8
    )  + 
      (-6.027  )*(X[,1] >= .8) + 
      -15.009*(X[,1] <= .2 )
    #plot(Y~X[,1], type = 'p')
    
  }
  
  return(Y)
}# end camel function