setwd("Location of GPfunctions.R and test_functions.R")
source("GPfunctions.R")
source("test_functions.R")


########################################
name="hartmann6"
delta=0.3
rho=0.02
m=200
Nadd=10
N=70
P=15
tau=sqrt(0.05)
temp  = sim_initial_XY(name, N, P, tau)
X    = temp$X
colnames(X) = paste0("X",1:P)
Y    = temp$Y


#######################################
## SOLID
#######################################
X<-X[1:N,]
Y<-Y[1:N]
trace=TRUE
Results.SOLID<-list()
st<-proc.time()
for(i in 0:Nadd){
   #Label iterations i0 to i25
    up<-paste("i",i,sep="")
   if(i==0){
      #Run SOLID with default MCMC
        Results.SOLID[[up]]<-SOLID(Y=Y,X=X,delta=delta,rho=rho,m=m)
      #Calculate max.Y at predicted maxloc (camel function needs matrix of points)
        stages<-length(Results.SOLID[[up]])
        maxloc.Y<-camel(rbind(X,Results.SOLID[[up]][[stages]]$maxloc),P,name)[N+1]
        Results.SOLID[[up]][[stages]]$maxloc.Y=maxloc.Y 
        #Save Y responses
        Results.SOLID[[up]][[stages]]$Y<-Y
   }else{
      #Grab results from previous i
         prev.up<-paste("i",i-1,sep="")
         prev.stages<-length(Results.SOLID[[prev.up]])
      #Update original X matrix (with all variables)
         X<-rbind(X,Results.SOLID[[prev.up]][[prev.stages]]$xnew)
      #Update original Y with Y(xnew) + error with sd=tau (declared earlier)
         Y<-c(Y,camel(X,P,name)[N+i]
                                  +rnorm(1,0,tau))
      #Run SOLID but only with globally active variables
         Pnew<-Results.SOLID[[prev.up]][[prev.stages]]$Pnew
         Xup<-X[,Pnew]
         Results.SOLID[[up]]<-SOLID(Y=Y,X=Xup,delta=delta,rho=rho,m=m)
      #At this point, Pnew in Results.SOLID are subset of Pnew index
      #Need to update indexing
         stages<-length(Results.SOLID[[up]])
         for(s in 1:stages){
            #Make Pnew in terms of all variables, not relative to Xup
            Results.SOLID[[up]][[s]]$Pnew<-Pnew[Results.SOLID[[up]][[s]]$Pnew]
            #Make maxloc in terms of all variables, not relative to Xup
            #Need to grab previous maxloc values for inactive variables
            holdmax<-Results.SOLID[[up]][[s]]$maxloc
               Results.SOLID[[up]][[s]]$maxloc<-Results.SOLID[[prev.up]][[prev.stages]]$maxloc
               Results.SOLID[[up]][[s]]$maxloc[Pnew]<-holdmax
         }
         #For final stage only, fix xnew
          holdxnew<-Results.SOLID[[up]][[stages]]$xnew
          Results.SOLID[[up]][[stages]]$xnew<-Results.SOLID[[prev.up]][[prev.stages]]$xnew
          Results.SOLID[[up]][[stages]]$xnew[Pnew]<-holdxnew
         
         #Calculate max at predicted maxloc (camel function needs  matrix of points)
          maxloc.Y<-camel(rbind(X,Results.SOLID[[up]][[stages]]$maxloc),P,name)[N+(i+1)]
          Results.SOLID[[up]][[stages]]$maxloc.Y=maxloc.Y 
          
         #Save Y responses
          Results.SOLID[[up]][[stages]]$Y<-Y
         
   }#End else for i>0
   if(trace){
      print(paste(up,"Max Value=",round(maxloc.Y,5)))
      Pnew<-Results.SOLID[[up]][[stages]]$Pnew
      print("Globally Active Set:")
      print(Pnew)
      print("Locally Active Set:")
      print(Pnew[Results.SOLID[[up]][[stages]]$LVSresults$A])
   }
    
}#end loop
sp<-proc.time()
print("SOLID Time:")
print((sp-st)/3600)
#Saves time to complete
Results.SOLID$time=(sp-st)/3600


#####################################
### None
#####################################
X<-X[1:N,]
Y<-Y[1:N]
trace=TRUE
Results.None<-list()
st<-proc.time()
for(i in 0:Nadd){
   up<-paste("i",i,sep="")
   if(i==0){
      #Run None
       Results.None[[up]]<-None(Y,X)
      #Calculate max at predicted maxloc (camel function needs  matrix of points)
       maxloc.Y<-camel(rbind(X,Results.None[[up]][[1]]$maxloc),P,name)[N+1]
       Results.None[[up]][[1]]$maxloc.Y=maxloc.Y 
       
       #Save Y responses
       Results.None[[up]][[1]]$Y<-Y
       
   }else{
      #Grab results from previous i
       prev.up<-paste("i",i-1,sep="")
      #Update original X matrix (with all variables)
       X<-rbind(X,Results.None[[prev.up]][[1]]$xnew)
      #Update original Y with previous maxloc.Y + error according to tau2
       Y<-c(Y,
           camel(X,P,name)[N+i]+rnorm(1,0,tau))
      #Run None
       Pnew<-Results.None[[prev.up]][[1]]$Pnew #Will always be full variables
       Results.None[[up]]<-None(Y=Y,X=X)
      
      #Calculate max at predicted maxloc (camel function needs  matrix of points)
       maxloc.Y<-camel(rbind(X,Results.None[[up]][[1]]$maxloc),P,name)[N+(i+1)]
       Results.None[[up]][[1]]$maxloc.Y=maxloc.Y 
      
      #Save Y responses
       Results.None[[up]][[1]]$Y<-Y 
       
   }#End else for i>0
   if(trace){
      print(paste(up,"Max Value=",round(maxloc.Y,5)))
   }
   
}#end loop
sp<-proc.time()
print("None Time:")
print((sp-st)/3600)
#Saves time to complete
Results.None$time=(sp-st)/3600

#####################################
### Oracle
#####################################
X<-X[1:N,]
Y<-Y[1:N]
trace=TRUE
Results.Oracle<-list()
Xora<-X[,1:6]
st<-proc.time()
for(i in 0:Nadd){
   up<-paste("i",i,sep="")
   if(i==0){
      #Run None but with Xora
       Results.Oracle[[up]]<-None(Y,Xora)
      #Calculate max at predicted maxloc (camel function needs  matrix of points)
       maxloc.Y<-camel(rbind(Xora,Results.Oracle[[up]][[1]]$maxloc),P=6,name)[N+1]
       Results.Oracle[[up]][[1]]$maxloc.Y=maxloc.Y 
       #Save Y responses
       Results.Oracle[[up]][[1]]$Y<-Y
   }else{
      #Grab results from previous i
       prev.up<-paste("i",i-1,sep="")
      #Update original X matrix (with all variables)
       Xora<-rbind(Xora,Results.Oracle[[prev.up]][[1]]$xnew)
      #Update original Y with previous maxloc.Y + error according to tau2
       Y<-c(Y,camel(Xora,P=6,name)[N+i]
                                 +rnorm(1,0,tau))
      #Run SOLID but only with globally active variables
       Pnew<-Results.Oracle[[prev.up]][[1]]$Pnew #Always first six variables
       Results.Oracle[[up]]<-None(Y=Y,X=Xora)
      
      #Calculate max at predicted maxloc (camel function needs  matrix of points)
       maxloc.Y<-camel(rbind(Xora,Results.Oracle[[up]][[1]]$maxloc),P=6,name)[N+(i+1)]
       Results.Oracle[[up]][[1]]$maxloc.Y=maxloc.Y 
      
      #Save Y responses
       Results.Oracle[[up]][[1]]$Y<-Y 
       
   }#End else for i>0
   if(trace){
      print(paste(up,"Max Value=",round(maxloc.Y,5)))
   }
   
}#end loop
sp<-proc.time()
print("Oracle Time:")
print((sp-st)/3600)
Results.Oracle[[up]]$time<-(sp-st)/3600


#######################################
## GVS
#######################################
X<-X[1:N,]
Y<-Y[1:N]
trace=TRUE
Results.GVS<-list()
st<-proc.time()
for(i in 0:Nadd){
   up<-paste("i",i,sep="")
   if(i==0){
      #Run GVS
       Results.GVS[[up]]<-GVS(Y=Y,X=X)
      #Calculate max at predicted maxloc (camel function needs  matrix of points)
       stages<-length(Results.GVS[[up]])
       maxloc.Y<-camel(rbind(X,Results.GVS[[up]][[stages]]$maxloc),P,name)[N+1]
       Results.GVS[[up]][[stages]]$maxloc.Y=maxloc.Y
      #Save Y responses
       Results.GVS[[up]][[stages]]$Y<-Y
   }else{
      #Grab results from previous i
       prev.up<-paste("i",i-1,sep="")
       prev.stages<-length(Results.GVS[[prev.up]])
      #Update original X matrix (with all variables)
       X<-rbind(X,Results.GVS[[prev.up]][[prev.stages]]$xnew)
      #Update original Y with previous maxloc.Y + error according to tau2
       Y<-c(Y,
            camel(X,P,name)[N+i]+rnorm(1,0,tau)
                              )
      #Run GVS but only with globally active variables
       Pnew<-Results.GVS[[prev.up]][[prev.stages]]$Pnew
       Xup<-X[,Pnew]
       Results.GVS[[up]]<-GVS(Y=Y,X=Xup)
      #Need to update index information
       stages<-length(Results.GVS[[up]])
       for(s in 1:stages){
         #Make Pnew in terms of all variables, not relative to Xup
          Results.GVS[[up]][[s]]$Pnew<-Pnew[Results.GVS[[up]][[s]]$Pnew]
         #Make maxloc in terms of all variables, not relative to Xup
          holdmax<-Results.GVS[[up]][[s]]$maxloc
          Results.GVS[[up]][[s]]$maxloc<-Results.GVS[[prev.up]][[prev.stages]]$maxloc
          Results.GVS[[up]][[s]]$maxloc[Pnew]<-holdmax
       }
      #For final stage only, fix xnew
       holdxnew<-Results.GVS[[up]][[stages]]$xnew
       Results.GVS[[up]][[stages]]$xnew<-Results.GVS[[prev.up]][[prev.stages]]$xnew
       Results.GVS[[up]][[stages]]$xnew[Pnew]<-holdxnew
      
      #Calculate max at predicted maxloc (camel function needs  matrix of points)
       maxloc.Y<-camel(rbind(X,Results.GVS[[up]][[stages]]$maxloc),P,name)[N+(i+1)]
       Results.GVS[[up]][[stages]]$maxloc.Y=maxloc.Y 
      
      #Save Y responses
       Results.GVS[[up]][[stages]]$Y<-Y
      
   }#End else for i>0
   if(trace){
      print(paste(up,"Max Value=",round(maxloc.Y,5)))
      Pnew<-Results.GVS[[up]][[stages]]$Pnew
      print("Globally Active Set:")
      print(Pnew)
   }
   
}#end loop
sp<-proc.time()
print("GVS Time:")
print((sp-st)/3600)
Results.GVS$time<-(sp-st)/3600
