#### Paper: “On the Role of Minimum Variances in Weighted Optimal Designs”
### This code generates examples from paper section 3

# Read in functions
source("Weighted_Fun.R")

## Completely Randomized Design (CRD)
testH = matrix(c(1, -1,  0,  0,
                 1,  1, -1,  -1,
                 0,  0,  1, -1), 
               nrow = 3, ncol = 4, byrow = T)
N = 16

# Normalize H
Hnorm = t(apply(testH, 1, function(x) x/c(sqrt(t(x) %*% x))))

# Rank-restricted c-optimal variance lower bound
opt_exact_n   = c(apply(Hnorm, 1, function(x) sum((x^2)/ approx_c_CRD(N, x)) )) # Exact Design

# weights set using variance lower bounds

### unscaled weights
# s.t. sum weights = 1
q = 1:100

# scale weights so that they sum to 1 (w)
unscaled_weights = matrix(c(q, rep(1, length(q)), rep(1, length(q)))/(q + 2), nrow = length(q), ncol = 3)

# divide by minimum possible variance (w*)
weights = t(apply(unscaled_weights, 1, function(x) x/opt_exact_n))

# Exact design ratio of weighted variance to optimal variance 
var_ratiolb = t(apply(weights, 1, function(x) var_fun(exact_A_CRD(N, x, Hnorm)$Reps, Hnorm)/opt_exact_n))

# produces results for Table 1
Tab = cbind(unscaled_weights[, 1], var_ratiolb)
